/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.area;

import de.z0rdak.yawp.core.area.AbstractArea;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.IMarkableArea;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import org.apache.commons.lang3.NotImplementedException;

public class Polygon3DArea
extends AbstractArea {
    private List<class_2338> positions;

    private Polygon3DArea() {
        super(AreaType.POLYGON_3D);
        this.positions = new ArrayList<class_2338>();
    }

    public Polygon3DArea(List<class_2338> positions) {
        this();
        this.positions = positions;
    }

    public Polygon3DArea(class_2487 nbt) {
        super(nbt);
        this.deserializeNBT(nbt);
    }

    private static double calcAngleSum(class_2338 q, List<class_2338> posList, int n) {
        double ESPILON = 1.0E-7;
        double angleSum = 0.0;
        for (int i = 0; i < n; ++i) {
            double m2;
            class_2338 p1 = posList.get(i).method_10059((class_2382)q);
            class_2338 p2 = posList.get((i + 1) % n).method_10059((class_2382)q);
            double m1 = Polygon3DArea.modulus(p1);
            if (m1 * (m2 = Polygon3DArea.modulus(p2)) <= 1.0E-7) {
                return Math.PI * 2;
            }
            double cosTheta = (double)(p1.method_10263() * p2.method_10263() + p1.method_10264() * p2.method_10264()) + (double)(p1.method_10260() * p2.method_10260()) / (m1 * m2);
            angleSum += Math.acos(cosTheta);
        }
        return angleSum;
    }

    private static double modulus(class_2338 p) {
        return Math.sqrt(p.method_10263() * p.method_10263() + p.method_10264() * p.method_10264() + p.method_10260() * p.method_10260());
    }

    public List<class_2338> getPositions() {
        return Collections.unmodifiableList(this.positions);
    }

    @Override
    public boolean contains(class_2338 q) {
        return Polygon3DArea.calcAngleSum(q, this.positions, this.positions.size()) == Math.PI * 2;
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 nbt = super.serializeNBT();
        class_2499 pointList = new class_2499();
        this.positions.forEach(point -> {
            class_2520 pointNbt = class_2512.method_10692((class_2338)point);
            pointList.add((Object)pointNbt);
        });
        nbt.method_10566("blocks", (class_2520)pointList);
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.positions.clear();
        this.deserializeNBT(nbt);
        class_2499 pointList = nbt.method_10554("blocks", 10);
        for (int i = 0; i < pointList.size(); ++i) {
        }
    }

    public String toString() {
        throw new NotImplementedException("Missing toString");
    }

    @Override
    public Set<class_2338> markedBlocks() {
        return new HashSet<class_2338>(this.positions);
    }

    @Override
    public Set<class_2338> getHull() {
        throw new NotImplementedException("ChunkArea.getHull() not implemented yet");
    }

    @Override
    public Set<class_2338> getFrame() {
        return Set.of();
    }

    @Override
    public Set<class_2338> getMinimalOutline() {
        return Set.of();
    }

    @Override
    public boolean containsOther(IMarkableArea other) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public boolean intersects(IMarkableArea other) {
        throw new NotImplementedException("Not yet implemented");
    }
}

